<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml"
                              xmlns:html="http://www.w3.org/1999/xhtml"
                              xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:wwmode="urn:WebWorks-Engine-Mode"
                              xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                              xmlns:wwlinks="urn:WebWorks-Engine-Links-Schema"
                              xmlns:wwfiles="urn:WebWorks-Engine-Files-Schema"
                              xmlns:wwdoc="urn:WebWorks-Document-Schema"
                              xmlns:wwsplits="urn:WebWorks-Engine-Splits-Schema"
                              xmlns:wwtoc="urn:WebWorks-Engine-TOC-Schema"
                              xmlns:wwproject="urn:WebWorks-Publish-Project"
                              xmlns:wwpage="urn:WebWorks-Page-Template-Schema"
                              xmlns:wwprogress="urn:WebWorks-XSLT-Extension-Progress"
                              xmlns:wwlog="urn:WebWorks-XSLT-Extension-Log"
                              xmlns:wwfilesystem="urn:WebWorks-XSLT-Extension-FileSystem"
                              xmlns:wwuri="urn:WebWorks-XSLT-Extension-URI"
                              xmlns:wwstring="urn:WebWorks-XSLT-Extension-StringUtilities"
                              xmlns:wwfilesext="urn:WebWorks-XSLT-Extension-Files"
                              xmlns:wwprojext="urn:WebWorks-XSLT-Extension-Project"
                              xmlns:wwexsldoc="urn:WebWorks-XSLT-Extension-Document"
                              exclude-result-prefixes="xsl wwmode msxsl wwlinks wwfiles wwdoc wwsplits wwtoc wwproject wwpage wwprogress wwlog wwfilesystem wwuri wwstring wwfilesext wwprojext wwexsldoc"
>
 <xsl:output method="xml" version="1.0" indent="yes" encoding="iso-8859-1" />
 <xsl:namespace-alias stylesheet-prefix="html" result-prefix="#default" />


 <xsl:include href="pagetemplate.xsl" />


 <xsl:template match="/">
  <xsl:variable name="VarConditionsAsXML">
   <wwpage:Condition name="breadcrumbs-top" />
   <wwpage:Condition name="breadcrumbs-bottom" />
   <wwpage:Condition name="navigation-top" />
   <wwpage:Condition name="navigation-bottom" />
   <wwpage:Condition name="navigation-toc-current" />
   <wwpage:Condition name="navigation-toc-not-current" />
   <wwpage:Condition name="navigation-previous-exists" />
   <wwpage:Condition name="navigation-previous-not-exists" />
   <wwpage:Condition name="navigation-next-exists" />
   <wwpage:Condition name="navigation-next-not-exists" />
   <wwpage:Condition name="navigation-index-current" />
   <wwpage:Condition name="navigation-index-not-current" />
  </xsl:variable>
  <xsl:variable name="VarConditions" select="msxsl:node-set($VarConditionsAsXML)" />

  <xsl:variable name="VarReplacementsAsXML">
   <wwpage:Replacement name="title" value="title" />
   <wwpage:Replacement name="navigation-toc-title" value="navigation-toc-title" />
   <wwpage:Replacement name="navigation-previous-title" value="navigation-previous-title" />
   <wwpage:Replacement name="navigation-next-title" value="navigation-next-title" />
   <wwpage:Replacement name="navigation-index-title" value="navigation-index-title" />
   <wwpage:Replacement name="breadcrumbs" value="breadcrumbs" />
   <wwpage:Replacement name="content" value="content" />
   <wwpage:Replacement name="copy-relative-to-output" value="copy-relative-to-output" />
   <wwpage:Replacement name="relative-to-output" value="relative-to-output" />
   <wwpage:Replacement name="catalog-css" value="catalog-css" />
   <wwpage:Replacement name="locale" value="en" />
   <wwpage:Replacement name="navigation-top-style" value="text-align: right;" />
   <wwpage:Replacement name="navigation-bottom-style" value="text-align: center;" />
   <wwpage:Replacement name="navigation-toc-link" value="navigation-toc-link" />
   <wwpage:Replacement name="navigation-previous-link" value="navigation-previous-link" />
   <wwpage:Replacement name="navigation-next-link" value="navigation-next-link" />
   <wwpage:Replacement name="navigation-index-link" value="navigation-index-link" />
  </xsl:variable>
  <xsl:variable name="VarReplacements" select="msxsl:node-set($VarReplacementsAsXML)" />

  <xsl:apply-templates select="/" mode="wwmode:pagetemplate">
   <xsl:with-param name="ParamOutputDirectoryPath" select="'D:\Builds\mainline\source\files\webworks\Transforms\html'" />
   <xsl:with-param name="ParamConditions" select="$VarConditions" />
   <xsl:with-param name="ParamReplacements" select="$VarReplacements" />
   <xsl:with-param name="ParamSplits" select="/*" />
   <xsl:with-param name="ParamLinks" select="/*" />
   <xsl:with-param name="ParamTOCData" select="/*" />
   <xsl:with-param name="ParamBreadcrumbTOCEntry" select="/*" />
   <xsl:with-param name="ParamSplit" select="/*" />
   <xsl:with-param name="ParamPageRule" select="/*" />
   <xsl:with-param name="ParamCSSPath" select="'csspath.css'" />
   <xsl:with-param name="ParamContent" select="/*" />
  </xsl:apply-templates>
 </xsl:template>
</xsl:stylesheet>
